#ifndef _IStreamposActions_h__
#define _IStreamposActions_h__

#include <buildspec.h>
#include <config.h>

#include <ios>

namespace GST
{
namespace Geometry
{

class GST_API_EXPORT IStreamposActions
{
protected:
	std::string header;
	std::string footer;

public:
	IStreamposActions() : header(""), footer("")
	{
	}
	virtual ~IStreamposActions()
	{
	}

	virtual void NewObject(const std::streampos &firstPos,
						   const std::streampos &lastPos)
		= 0;
	virtual void NewObject(const std::string &content)
	{
		// overload me!
	}
	virtual void setHeader(const std::string &header)
	{
		this->header = header;
	}
	virtual void setFooter(const std::string &footer)
	{
		this->footer = footer;
	}
};

} // namespace Geometry
} // namespace GST

#endif // _IStreamposActions_h__
